<?php
defined ( 'BAIFU_PATH' ) or exit ();
/**
 * 分页类
 */
class Pager {
	protected $page;
	protected $totalPages;
	protected $total;
	protected $showPages;
	protected $showPagesize;
	
	public $pagesize;
	public $offset;
	public $isShowSummary = true;
	public $isShowItems = true;
	public $isShowFirst = true;
	public $isShowLast = true;
	public $isShowPrevious = true;
	public $isShowNext = true;
	public function __construct($total = 0, $page = 0, $pagesize = 0, $showPagesize = 0) {
		$this->page = intval ( $page ) ? intval ( $page ) : (intval ( $_GET ['page'] ) ? intval ( $_GET ['page'] ) : 1);
		$this->pagesize = intval ( $pagesize ) ? intval ( $pagesize ) : (intval ( $_GET ['pagesize'] ) && defined ( 'IN_ADMIN' ) ? intval ( $_GET ['pagesize'] ) : 10);
		$this->showPagesize = intval ( $showPagesize ) ? $showPagesize : 10;
		$this->setTotal ( $total );
	}
	
	public function __toString(){
		$result = '';
		if ($this->totalPages > 1) {
			$showPages = $this->showPagesize + 1;
			$offset = ceil ( $this->showPagesize / 2 - 1 );
			$from = $this->page - $offset;
			$to = $this->page + $offset;
			if ($showPages >= $this->totalPages) {
				$from = 2;
				$to = $this->totalPages - 1;
			} else {
				if ($from <= 1) {
					$to = $showPages - 1;
					$from = 2;
				} elseif ($to >= $this->totalPages) {
					$from = $this->totalPages - ($showPages - 2);
					$to = $this->totalPages - 1;
				}
			}
			if ($this->isShowFirst) {
				$result .= $this->url ( 1, '第一页' );
			}
			if ($this->isShowPrevious && $this->page > 1) {
				$result .= $this->url ( $this->page - 1, '上一页' );
			}
			if ($this->isShowItems) {
				if ($this->page == 1) {
					$result .= ' <li><span>1</span></li>';
				} elseif ($showPages < $this->totalPages && $this->page > ceil ( $this->showPagesize / 2 + 1 )) {
					$result .= $this->url ( 1, '1..' );
				} else {
					$result .= $this->url ( 1, '1' );
				}
				
				for($i = $from; $i <= $to; $i ++) {
					if ($i != $this->page) {
						$result .= $this->url ( $i, $i );
					} else {
						$result .= ' <li><span>' . $i . '</span></li>';
					}
				}
				
				if ($this->page < $this->totalPages) {
					if ($showPages < $this->totalPages && $this->page < $this->totalPages - ceil ( $this->showPagesize / 2 )) {
						$result .= $this->url ( $this->totalPages, '..' . $this->totalPages );
					} else {
						$result .= $this->url ( $this->totalPages, $this->totalPages );
					}
				} elseif ($this->page == $this->totalPages) {
					$result .= ' <li><span>' . $this->totalPages . '</span></li>';
				} else {
					$result .= $this->url ( $this->totalPages, $this->totalPages );
				}
			}
			if ($this->isShowNext && $this->page < $this->totalPages) {
				$result .= $this->url ( $this->page + 1, '下一页' );
			}
			if ($this->isShowLast) {
				$result .= $this->url ( $this->totalPages, '最后一页' );
			}
			if ($this->isShowSummary) {
				$result .= sprintf ( '<li class="total-summary"> %s / %s 页 共 %s 条</li>', $this->page, $this->totalPages, $this->total );
			}
			if (! empty ( $result )) {
				$result = "<div class='pager'><ul>$result</ul></div>";
			}
		}
		return $result;
	}
	
	/**
	 * 生成页码标签
	 */
	function url($page, $text, $class = '') {
		$url = WEB_CURRENT_URL;
		parse_str ( $par, $_pars );
		$query_array = array();
		$pos = strpos ( $url, '?' );
		if ($pos !== false) {
			$querystring = substr ( strstr ( $url, '?' ), 1 );
			parse_str ( $querystring, $pars );
			foreach ( $pars as $k => $v ) {
				if ($k != 'page')
					$query_array [$k] = $v;
			}
			$url = substr ( $url, 0, $pos );
		}
		$query_array['page'] = $page;
		$qstr = '';
		foreach ( array_filter ( array_merge ( $query_array, $_pars ) ) as $k => $v ) {
			$qstr .= ($qstr ? '&' : '?') . $k . '=' . $v;
		}
		$url = $url . $qstr;
		return "<li class='$class'><a href='$url'>$text</a></li>";
	}
	
	public function setShowPagesize($pagesize) {
		$this->showPagesize = intval ( $pagesize );
		if ($this->showPagesize < 1) {
			$this->showPagesize = 10;
		}
		return $this;
	}
	public function setPagesize($pagesize) {
		$this->pagesize = intval ( $pagesize );
		if ($this->pagesize < 1) {
			$this->pagesize = 10;
		}
		$this->setTotal ( $this->total );
		return $this;
	}
	public function setPage($page) {
		$this->page = intval ( $page );
		if ($this->page < 1) {
			$this->page = 1;
		}
		$this->setTotal ( $this->total );
		return $this;
	}
	public function setTotal($total) {
		$this->total = intval ( $total );
		if ($this->total > 0) {
			$this->totalPages = ceil ( $this->total / $this->pagesize );
			if (! empty ( $this->totalPages ) && $this->page > $this->totalPages) {
				$this->page = $this->totalPages;
			}
			$this->offset = $this->pagesize * ($this->page - 1);
		}
		return $this;
	}

}
?>