<?php
class Dir {

	
	/**
	 * 删除目录（包括下面的文件）
	 */
	static function delete($directory, $subdir = true) {
		if (is_dir ( $directory ) == false) {
			return false;
		}
		$handle = opendir ( $directory );
		while ( ($file = readdir ( $handle )) !== false ) {
			if ($file != "." && $file != "..") {
				is_dir ( "$directory/$file" ) ? Dir::delete ( "$directory/$file" ) : unlink ( "$directory/$file" );
			}
		}
		if (readdir ( $handle ) == false) {
			closedir ( $handle );
			rmdir ( $directory );
		}
	}
	
	/**
	 * 删除目录下面的所有文件，但不删除目录
	 * @access static
	 * @return bool
	 */
	static function clear($directory) {
		if (is_dir ( $directory ) == false) {
			return false;
		}
		$handle = opendir ( $directory );
		while ( ($file = readdir ( $handle )) !== false ) {
			if ($file != "." && $file != ".." && is_file ( "$directory/$file" )) {
				unlink ( "$directory/$file" );
			}
		}
		closedir ( $handle );
		return true;
	}
	
	/**
	 * 复制目录
	*/
	static function copy($source, $destination) {
		if (is_dir ( $source ) == false) {
			exit ( "The Source Directory Is Not Exist!" );
		}
		if (is_dir ( $destination ) == false) {
			mkdir ( $destination, 0700 );
		}
		$handle = opendir ( $source );
		while ( false !== ($file = readdir ( $handle )) ) {
			if ($file != "." && $file != "..") {
				is_dir ( "$source/$file" ) ? Dir::copy ( "$source/$file", "$destination/$file" ) : copy ( "$source/$file", "$destination/$file" );
			}
		}
		closedir ( $handle );
	}
	
	/**
	 * 转化 \ 为 /
	 * @param	string	$path	路径
	 * @return	string	路径
	 */
	static function path($path) {
		$path = str_replace ( '\\', '/', $path );
		if (substr ( $path, - 1 ) != '/')
			$path = $path . '/';
		return $path;
	}
	/**
	 * 创建目录
	 * @param	string	$path	路径
	 * @param	string	$mode	属性
	 * @return	string	如果已经存在则返回true，否则为flase
	 */
	static function create($path, $mode = 0755,$isBuildSafeFile=true) {
		if (is_dir ( $path ))
			return TRUE;
		defined('DIR_SECURE_FILENAME')  or define('DIR_SECURE_FILENAME',    'index.html');
        defined('DIR_SECURE_CONTENT')   or define('DIR_SECURE_CONTENT',     ' ');
		$path = Dir::path ( $path );
		$temp = explode ( '/', $path );
		$cur_dir = '';
		$max = count ( $temp ) - 1;
		for($i = 0; $i < $max; $i ++) {
			$cur_dir .= $temp [$i] . '/';
			if (@is_dir ( $cur_dir ))
				continue;
			@mkdir ( $cur_dir, $mode, true );
			@chmod ( $cur_dir, $mode );
			if($isBuildSafeFile){
				$content = DIR_SECURE_CONTENT;
        		$files = explode(',', DIR_SECURE_FILENAME);
	            foreach ($files as $filename){
	                file_put_contents($cur_dir.$filename,$content);
	            }
			}
		}
		return is_dir ( $path );
	}

	/**
	 * 是否可写
	 */
	static function is_writeable($file,$issingle=true) {
		if(strpos(strtoupper(PHP_OS), 'WIN') !== false) {
			if(substr($file, -1) == '/') {
				if(is_dir($file)) {
					$file = $file.'test.tmp';
					if(@$fp = fopen($file, 'a')) {
						flock($fp, LOCK_EX);
						fwrite($fp, 'OK');
						flock($fp, LOCK_UN);
						fclose($fp);
						$tmp = file_get_contents($file);
						unlink($file);
						if($tmp == 'OK'&&$issingle) return true;
						$list = glob ( $file . '*' );
						foreach ( $list as $v ) {
							if(!Dir::is_writeable($v,$issingle)) return false;
						}
						return true;
						
					}else{
						return false;
					}
				} else {
					Dir::create($file);
					if(is_dir($file)) return Dir::is_writeable($file,$issingle);
					return false;
				}
			} else {
				if(@$fp = fopen($file, 'a')) {
					fclose($fp);
					return true;
				}
				return false;
			}
		} else {
			return is_writable($file);
		}
	}

}
?>