<?php

/** 
 * 图像处理类 静态方法集合
 */
class Image {
	
	/**
	 * 取得图像信息
	 * @static
	 * @access public
	 * @param string $image 图像文件名
	 * @return mixed
	 */
	static function getImageInfo($img) {
		$imageInfo = getimagesize ( $img );
		if ($imageInfo !== false) {
			$imageType = strtolower ( substr ( image_type_to_extension ( $imageInfo [2] ), 1 ) );
			$imageSize = filesize ( $img );
			$info = array ("width" => $imageInfo [0], "height" => $imageInfo [1], "type" => $imageType, "size" => $imageSize, "mime" => $imageInfo ['mime'] );
			return $info;
		} else {
			return false;
		}
	}
	
	/**
	 * 显示服务器图像文件
	 * 支持URL方式
	 * @static
	 * @access public
	 * @param string $imgFile 图像文件名
	 * @param string $text 文字字符串
	 * @param string $width 图像宽度
	 * @param string $height 图像高度
	 * @return void
	 */
	static function showImg($imgFile, $text = '', $width = 80, $height = 30) {
		$info = Image::getImageInfo ( $imgFile );
		if ($info !== false) {
			$createFun = str_replace ( '/', 'createfrom', $info ['mime'] );
			$im = $createFun ( $imgFile );
			if ($im) {
				$ImageFun = str_replace ( '/', '', $info ['mime'] );
				if (! empty ( $text )) {
					$tc = imagecolorallocate ( $im, 0, 0, 0 );
					imagestring ( $im, 3, 5, 5, $text, $tc );
				}
				if ($info ['type'] == 'png' || $info ['type'] == 'gif') {
					imagealphablending ( $im, false );
					imagesavealpha ( $im, true );
				}
				header ( "Content-type: " . $info ['mime'] );
				$ImageFun ( $im );
				imagedestroy ( $im );
				return;
			}
		}
		$im = imagecreatetruecolor ( $width, $height );
		$bgc = imagecolorallocate ( $im, 255, 255, 255 );
		$tc = imagecolorallocate ( $im, 0, 0, 0 );
		imagefilledrectangle ( $im, 0, 0, 150, 30, $bgc );
		imagestring ( $im, 4, 5, 5, "NO PIC", $tc );
		Image::output ( $im );
		return;
	}
	
	/**
	 * 生成缩略图
	 * @static
	 * @access public
	 * @param string $image  原图
	 * @param string $thumbname 缩略图文件名
	 * @param string $maxWidth  宽度
	 * @param string $maxHeight  高度
	 * @param string $position 缩略图保存目录
	 * @param boolean $interlace 启用隔行扫描
	 * @param string $type 图像格式
	 * @return void
	 */
	static function thumb($image, $thumbname, $maxWidth = 200, $maxHeight = 50, $interlace = true, $type = '') {
		$info = Image::getImageInfo ( $image );
		if ($info !== false) {
			$srcWidth = $info ['width'];
			$srcHeight = $info ['height'];
			$type = empty ( $type ) ? $info ['type'] : $type;
			$type = strtolower ( $type );
			$interlace = $interlace ? 1 : 0;
			unset ( $info );
			$scale = min ( $maxWidth / $srcWidth, $maxHeight / $srcHeight );
			if ($scale >= 1) {
				$width = $srcWidth;
				$height = $srcHeight;
			} else {
				$width = ( int ) ($srcWidth * $scale);
				$height = ( int ) ($srcHeight * $scale);
			}
			
			$createFun = 'ImageCreateFrom' . ($type == 'jpg' ? 'jpeg' : $type);
			$srcImg = $createFun ( $image );
			
			if ($type != 'gif' && function_exists ( 'imagecreatetruecolor' ))
				$thumbImg = imagecreatetruecolor ( $width, $height );
			else
				$thumbImg = imagecreate ( $width, $height );
			
			if (function_exists ( "ImageCopyResampled" ))
				imagecopyresampled ( $thumbImg, $srcImg, 0, 0, 0, 0, $width, $height, $srcWidth, $srcHeight );
			else
				imagecopyresized ( $thumbImg, $srcImg, 0, 0, 0, 0, $width, $height, $srcWidth, $srcHeight );
			if ('gif' == $type || 'png' == $type) {
				$background_color = imagecolorallocate ( $thumbImg, 0, 255, 0 );
				imagecolortransparent ( $thumbImg, $background_color );
			}
			
			if ('jpg' == $type || 'jpeg' == $type)
				imageinterlace ( $thumbImg, $interlace );
			
			$imageFun = 'image' . ($type == 'jpg' ? 'jpeg' : $type);
			$imageFun ( $thumbImg, $thumbname );
			imagedestroy ( $thumbImg );
			imagedestroy ( $srcImg );
			return $thumbname;
		}
		return false;
	}
	
	/**
	 * 生成验证码
	 * @static
	 * @access public
	 * @param string $length  位数
	 * @param string $type 图像格式
	 * @param string $width  宽度
	 * @param string $height  高度
	 * @return string
	 */
	static function buildCaptcha($length = 4, $type = 'png', $width = 40, $height = 20, $session = 'captcha') {
		$randval = Random ( $length );
		$_SESSION [$session] = md5 ( $randval );
		$width = ($length * 10 + 10) > $width ? $length * 10 + 10 : $width;
		if ($type != 'gif' && function_exists ( 'imagecreatetruecolor' )) {
			$im = @imagecreatetruecolor ( $width, $height );
		} else {
			$im = @imagecreate ( $width, $height );
		}
		$r = Array (225, 255, 255, 223 );
		$g = Array (255, 250, 255, 255 );
		$b = Array (225, 240, 200, 255 );
		$key = mt_rand ( 0, 3 );
		
		$backColor = imagecolorallocate ( $im, $r [$key], $g [$key], $b [$key] );
		$borderColor = imagecolorallocate ( $im, 150, 150, 150 );
		$pointColor = imagecolorallocate ( $im, mt_rand ( 0, 255 ), mt_rand ( 0, 255 ), mt_rand ( 0, 255 ) );
		

		@imagefilledrectangle ( $im, 0, 0, $width - 1, $height - 1, $backColor );
		@imagerectangle ( $im, 0, 0, $width - 1, $height - 1, $borderColor );
		$stringColor = imagecolorallocate ( $im, mt_rand ( 0, 200 ), mt_rand ( 0, 120 ), mt_rand ( 0, 120 ) );
		for($i = 0; $i < 10; $i ++) {
			$fontcolor = imagecolorallocate ( $im, mt_rand ( 0, 255 ), mt_rand ( 0, 255 ), mt_rand ( 0, 255 ) );
			imagearc ( $im, mt_rand ( - 10, $width ), mt_rand ( - 10, $height ), mt_rand ( 30, 300 ), mt_rand ( 20, 200 ), 55, 44, $fontcolor );
		}
		for($i = 0; $i < 25; $i ++) {
			$fontcolor = imagecolorallocate ( $im, mt_rand ( 0, 255 ), mt_rand ( 0, 255 ), mt_rand ( 0, 255 ) );
			imagesetpixel ( $im, mt_rand ( 0, $width ), mt_rand ( 0, $height ), $pointColor );
		}
		for($i = 0; $i < $length; $i ++) {
			imagestring ( $im, 5, $i * 10 + 5, mt_rand ( 1, 8 ), $randval {$i}, $stringColor );
		}
		Image::output ( $im, $type );
	}
	
	static function output($im, $type = 'png', $filename = '') {
		header ( "Content-type: image/" . $type );
		$ImageFun = 'image' . $type;
		if (empty ( $filename )) {
			$ImageFun ( $im );
		} else {
			$ImageFun ( $im, $filename );
		}
		imagedestroy ( $im );
	}

}
?>