<?php
/**
 * 系统配置文件管理类
 */
class Config {

    /**
	 * 当前设置
	 */
	public  static $config = array();

	/**
     * 获取指定类型的所有配置
     * @access public
     * @param string $name 名称
     * @return mixed
     */
    public static function type($name) {
        return isset(self::$config[$name])?self::$config[$name]:self::load($name);
    }
	/**
	 * 获取系统配置
	 * @param string $key 配置键
	 * @param mixed $value 配置值
	 * @return mixed
	 */
	public static function get($key = null, $default = null) {
		if (strpos ( $key, '.' ) !== false) {
			list ( $type, $key ) = explode ( '.', $key );
		} else {
			$type = 'GLOBAL';
		}
		$value = self::type($type);
		$value = $value [$key];
		if (is_null ( $value ))
			$value = $default;
		return $value;
	}
	
	/**
	 * 设置系统配置
	 * @param string|array $key 配置键
	 * @param mixed $value 配置值
	 * @return mixed
	 */
	public static function set($key = null, $value = null) {
		if (is_array ( $value )) {
			if(isset(self::$config [$key])){
				self::$config [$key] = array_merge(self::$config [$key],$value);
			}else{
				self::$config [$key] = $value;
			}
		} else {
		
			if(is_null($value)){
				unset(self::$config ['GLOBAL'] [$key]);
			}else{
				self::$config ['GLOBAL'] [$key] = $value;
			}
		}
	}
	/**
	 * 加载配置文件
	 * @param string|array $file 配置文件
	 * @return mixed
	 */
	public static function load($file) {
		if (is_array ( $file )) {
			foreach ( $file as $v ) {
				self::load ( $v);
			}
		} else {
			if (! file_exists ( $file )) {
				$file = APP_CONFIG_PATH . $file . '.php';
				if (! file_exists ( $file )) {
					return array();
				}
			}
			$type = basename ( $file, ".php" );
			$value = array_change_key_case(include ($file));
			if (isset ( self::$config [$type] )) {
				return self::$config [$type] = array_merge ( self::$config [$type], $value );
			} else {
				return self::$config [$type] = $value;
			}
		}
		return array();
	}
    
}