<?php
defined ( 'BAIFU_PATH' ) or exit ( 'Access Denied' );
/**
 * Cache类
 */
class Cache {
	/**
	 * 架构函数
	 * @access public
	 */
	public function __construct() {
	
	}
	
	protected $config = array ('path' => APP_FILE_CACHE_PATH, 'expire' => 3600, 'prefix' => '' );
	/**
	 * 设置数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @param mixed $value 值
	 * @return void
	 */
	public function __set($name, $value) {
		$this->config [$name] = $value;
	}
	
	/**
	 * 获取数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return mixed
	 */
	public function __get($name) {
		return isset ( $this->config [$name] ) ? $this->config [$name] : null;
	}
	
	/**
	 * 检测数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return boolean
	 */
	public function __isset($name) {
		return isset ( $this->config [$name] );
	}
	
	/**
	 * 销毁数据对象的值
	 * @access public
	 * @param string $name 名称
	 * @return void
	 */
	public function __unset($name) {
		unset ( $this->config [$name] );
	}
	protected static $default = array ('name' => 'file', 'expire' => 3600, 'cache_limiter' => 'private, must-revalidate', 'auto_start' => TRUE );
	/** 
	 * 取得类实例
	 * @static
	 * @access public
	 * @return Cache 返回类实例
	 */
	public static function instance($config = array()) {
		$args = func_get_args ();
		static $_instance = array ();
		$identify = Guid ( $args );
		if (! isset ( $_instance [$identify] )) {
			$config = self::parseConfig ( $config );
			$o = new Cache ();
			$o->init ( $config );
			$_instance [$identify] = $o;
		}
		return $_instance [$identify];
	}
	/**
	 * 解析配置
	 * @access public
	 * @param array $config 自定义配置
	 * @return string
	 */
	public static function parseConfig($config = array()) {
		if (is_numeric ( $config )) {
			$config = array ('expire' => $config );
		}
		return array_merge ( self::$default, array_change_key_case ( $config ) );
	}
	/**
	 * 初始化
	 * @access public
	 * @param array $config 自定义配置
	 */
	public function init($config = array()) {
		$this->config = array_merge ( $this->config, $config );
		if (! is_dir ( $this->config ['path'] )) {
			Dir::create ( $this->config ['path'] );
		}
	}
	
	/**
	 * 取得变量的存储文件名
	 * @access private
	 * @param string $name 缓存变量名
	 * @return string
	 */
	private function filename($name) {
		$filename = $this->config ['prefix'] . $name . '.php';
		return $this->config ['path'] . $filename;
	}
	
	/**
	 * 读取缓存
	 * @access public
	 * @param string $name 缓存变量名
	 * @return mixed
	 */
	public function get($name) {
		$filename = $this->filename ( $name );
		if (! is_file ( $filename )) {
			return false;
		}
		$content = file_get_contents ( $filename );
		if (false !== $content) {
			$expire = ( int ) substr ( $content, 8, 12 );
			if ($expire != 0 && time () > filemtime ( $filename ) + $expire) {
				unlink ( $filename );
				return false;
			}
			$content = substr ( $content, 20, - 3 );
			$content = unserialize ( $content );
			return $content;
		} else {
			return false;
		}
	}
	
	/**
	 * 写入缓存
	 * @access public
	 * @param string $name 缓存变量名
	 * @param mixed $value  存储数据
	 * @param int $expire  有效时间 0为永久
	 * @return boolen
	 */
	public function set($name, $value, $expire = null) {
		if (is_null ( $expire )) {
			$expire = $this->config ['expire'];
		}
		$filename = $this->filename ( $name );
		$data = serialize ( $value );
		$data = "<?php\n//" . sprintf ( '%012d', $expire ) . $data . "\n?>";
		return file_put_contents ( $filename, $data );
	}
	
	/**
	 * 删除缓存
	 * @access public
	 * @param string $name 缓存变量名
	 * @return boolen
	 */
	public function delete($name) {
		$filename = $this->filename ( $name );
		return false !== strpos ( $name, '*' ) ? array_map ( "unlink", glob ( $filename ) ) : @unlink ( $filename );
	}
	
	/**
	 * 清除缓存
	 * @access public
	 * @param string $name 缓存变量名
	 * @return boolen
	 */
	public function clear() {
		return Dir::clear ( $this->config ['path'] );
	}

}